/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.entity.ai.GoToEntityPositionGoal;
import net.smileycorp.atlas.api.network.SimpleStringMessage;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.event.HordeBuildSpawntableEvent;
import net.smileycorp.hordes.common.event.HordeEndEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.common.event.HordeStartEvent;
import net.smileycorp.hordes.common.event.HordeStartWaveEvent;
import net.smileycorp.hordes.common.hordeevent.HordeEventRegister;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnEntry;
import net.smileycorp.hordes.common.hordeevent.capability.HordeWorldData;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.common.hordeevent.network.HordeSoundMessage;

class HordeEvent
implements IHordeEvent {
    private Set<MobEntity> entitiesSpawned = new HashSet<MobEntity>();
    private int timer = 0;
    private int day = 0;
    private int nextDay = -1;
    private boolean hasChanged = false;
    private Random rand = new Random();

    public HordeEvent() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            HordeWorldData data = HordeWorldData.getData(ServerLifecycleHooks.getCurrentServer().func_241755_D_());
            this.nextDay = data.getNextDay();
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.entitiesSpawned.clear();
        if (nbt.func_74764_b("timer")) {
            this.timer = nbt.func_74762_e("timer");
        }
        if (nbt.func_74764_b("nextDay")) {
            this.nextDay = nbt.func_74762_e("nextDay");
        }
        if (nbt.func_74764_b("day")) {
            this.day = nbt.func_74762_e("day");
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74768_a("nextDay", this.nextDay);
        nbt.func_74768_a("day", this.day);
        this.hasChanged = false;
        return nbt;
    }

    public void update(PlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && player != null && world.func_234923_W_() == World.field_234918_g_) {
            if (this.timer % (Integer)CommonConfigHandler.hordeSpawnInterval.get() == 0) {
                int amount = (int)((double)((Integer)CommonConfigHandler.hordeSpawnAmount.get()).intValue() * (1.0 + (double)(this.day / (Integer)CommonConfigHandler.hordeSpawnDays.get()) * ((Double)CommonConfigHandler.hordeSpawnMultiplier.get() - 1.0)));
                List players = world.func_217369_A();
                for (PlayerEntity entity : players) {
                    if (entity == player || !(player.func_70032_d((Entity)entity) <= 25.0f)) continue;
                    amount = (int)Math.floor((double)amount * (Double)CommonConfigHandler.hordeMultiplayerScaling.get());
                }
                this.spawnWave(player, amount);
            }
            --this.timer;
            if (this.timer == 0) {
                this.stopEvent(player, false);
            }
            this.hasChanged = true;
        }
    }

    @Override
    public void spawnWave(PlayerEntity player, int count) {
        this.cleanSpawns();
        World world = player.field_70170_p;
        HordeStartWaveEvent startEvent = new HordeStartWaveEvent(player, this, count);
        MinecraftForge.EVENT_BUS.post((Event)startEvent);
        if (startEvent.isCanceled()) {
            return;
        }
        count = startEvent.getCount();
        Vector3d basedir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
        BlockPos basepos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)player.func_233580_cy_(), (Vector3d)basedir, (double)75.0, (int)7, (int)0);
        int i = 0;
        while (basepos.equals((Object)player.func_233580_cy_())) {
            basedir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
            basepos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)player.func_233580_cy_(), (Vector3d)basedir, (double)75.0, (int)7, (int)0);
            if (++i != 20) continue;
            this.logInfo("Unable to find unlit pos for horde " + this + " ignoring light level");
            basepos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)player.func_233580_cy_(), (Vector3d)basedir, (double)75.0);
            break;
        }
        HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(player, HordeEventRegister.getSpawnTable(this.day), this);
        MinecraftForge.EVENT_BUS.post((Event)buildTableEvent);
        WeightedOutputs<HordeSpawnEntry> spawntable = buildTableEvent.spawntable;
        if (spawntable.isEmpty()) {
            this.logInfo("Spawntable is empty, stopping wave spawn.");
            return;
        }
        if (count > 0) {
            if (player instanceof ServerPlayerEntity) {
                HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((Object)new HordeSoundMessage(basedir, startEvent.getSound()), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        } else {
            this.logInfo("Stopping wave spawn because count is " + count);
        }
        for (int n = 0; n < count; ++n) {
            if (this.entitiesSpawned.size() > (Integer)CommonConfigHandler.hordeSpawnMax.get()) {
                this.logInfo("Can't spawn wave because max cap has been reached");
                return;
            }
            Vector3d dir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
            BlockPos pos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)basepos, (Vector3d)dir, (double)this.rand.nextInt(10));
            HordeSpawnEntry entry = (HordeSpawnEntry)spawntable.getResult(this.rand);
            EntityType<?> type = entry.getEntity();
            try {
                MobEntity entity = (MobEntity)type.func_200721_a(world);
                entity.func_70037_a(HordeEventRegister.getEntryFor(entity, this.day).getNBT());
                HordeSpawnEntityEvent spawnEntityEvent = new HordeSpawnEntityEvent(player, entity, pos, this);
                MinecraftForge.EVENT_BUS.post((Event)spawnEntityEvent);
                if (!spawnEntityEvent.isCanceled()) {
                    entity = spawnEntityEvent.entity;
                    entity.func_70037_a(entry.getNBT());
                    pos = spawnEntityEvent.pos;
                    entity.func_213386_a((IServerWorld)world, world.func_175649_E(pos), null, null, null);
                    entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    entity.func_110148_a(Attributes.field_233819_b_).func_111128_a(100.0);
                    if (!world.func_217376_c((Entity)entity)) {
                        Hordes.logError("Unable to spawn entity from " + type, new Exception());
                    }
                    ((IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null).resolve().get()).setPlayerUUID(player.func_110124_au().toString());
                    this.registerEntity(entity);
                    this.hasChanged = true;
                    entity.field_70715_bh.func_220888_c().forEach(goal -> goal.func_75251_c());
                    if (entity instanceof CreatureEntity) {
                        entity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)entity, new Class[0]));
                    }
                    entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal(entity, PlayerEntity.class, true));
                    entity.field_70714_bg.func_75776_a(6, (Goal)new GoToEntityPositionGoal(entity, (Entity)player));
                    continue;
                }
                this.logInfo("Entity spawn event has been cancelled, not spawning entity  of class " + type);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Hordes.logError("Unable to spawn entity from " + type, e);
            }
        }
    }

    private void cleanSpawns() {
        ArrayList<MobEntity> toRemove = new ArrayList<MobEntity>();
        for (MobEntity entity : this.entitiesSpawned) {
            LazyOptional optional;
            if (!(entity.func_233643_dh_() | !entity.func_70089_S()) || !(optional = entity.getCapability(Hordes.HORDESPAWN, null)).isPresent()) continue;
            IHordeSpawn cap = (IHordeSpawn)optional.resolve().get();
            cap.setPlayerUUID("");
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
    }

    @Override
    public boolean isHordeDay(PlayerEntity player) {
        World world = player.field_70170_p;
        if (world.field_72995_K | world.func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        return this.isActive(player) || Math.floor(world.func_72820_D() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue()) >= (double)this.nextDay;
    }

    public boolean isActive(PlayerEntity player) {
        return this.timer > 0;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void setPlayer(PlayerEntity player) {
        HashSet<MobEntity> toRemove = new HashSet<MobEntity>();
        for (MobEntity entity : this.entitiesSpawned) {
            if (entity != null) {
                GoToEntityPositionGoal task = null;
                for (PrioritizedGoal entry : (PrioritizedGoal[])entity.field_70714_bg.func_220888_c().toArray(PrioritizedGoal[]::new)) {
                    if (!(entry.func_220772_j() instanceof GoToEntityPositionGoal)) continue;
                    task = (GoToEntityPositionGoal)entry.func_220772_j();
                    break;
                }
                if (task == null) continue;
                entity.field_70714_bg.func_85156_a(task);
                entity.field_70714_bg.func_75776_a(6, (Goal)new GoToEntityPositionGoal(entity, (Entity)player));
                continue;
            }
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
        this.hasChanged = true;
    }

    @Override
    public void tryStartEvent(PlayerEntity player, int duration, boolean isCommand) {
        if (player != null) {
            World world = player.field_70170_p;
            if (world.func_234923_W_() == World.field_234918_g_) {
                HordeStartEvent startEvent = new HordeStartEvent(player, this, isCommand);
                MinecraftForge.EVENT_BUS.post((Event)startEvent);
                if (startEvent.isCanceled()) {
                    return;
                }
                HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(player, HordeEventRegister.getSpawnTable((int)Math.floor(world.func_72820_D() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue())), this);
                MinecraftForge.EVENT_BUS.post((Event)buildTableEvent);
                if (!buildTableEvent.spawntable.isEmpty()) {
                    this.timer = duration;
                    this.hasChanged = true;
                    this.sendMessage(player, startEvent.getMessage());
                    this.day = isCommand ? (int)Math.floor(world.func_72820_D() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue()) : this.nextDay;
                } else {
                    this.logInfo("Spawntable is empty, canceling event start.");
                }
                if (!isCommand) {
                    this.nextDay = HordeWorldData.getData((ServerWorld)world).getNextDay();
                }
            }
        } else {
            Hordes.logError("player is null for " + this.toString(), new NullPointerException());
        }
    }

    @Override
    public void setNextDay(int day) {
        this.nextDay = day;
    }

    @Override
    public int getNextDay() {
        return this.nextDay;
    }

    private void sendMessage(PlayerEntity player, String str) {
        HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(str), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public void stopEvent(PlayerEntity player, boolean isCommand) {
        HordeEndEvent endEvent = new HordeEndEvent(player, this, isCommand);
        MinecraftForge.EVENT_BUS.post((Event)endEvent);
        this.timer = 0;
        this.cleanSpawns();
        this.sendMessage(player, endEvent.getMessage());
        this.hasChanged = true;
    }

    @Override
    public void removeEntity(MobEntity entity) {
        this.entitiesSpawned.remove(entity);
    }

    @Override
    public void registerEntity(MobEntity entity) {
        if (!this.entitiesSpawned.contains(entity)) {
            this.entitiesSpawned.add(entity);
        }
    }

    public String toString(PlayerEntity player) {
        return "OngoingHordeEvent@" + Integer.toHexString(this.hashCode()) + "[player=" + (player == null ? "null" : player.func_200200_C_().getString()) + ", isActive=" + (this.timer > 0) + ", ticksLeft=" + this.timer + ", entityCount=" + this.entitiesSpawned.size() + ", nextDay=" + this.nextDay + ", day=" + this.day + "]";
    }

    private void logInfo(Object message) {
        Hordes.logInfo("[" + this + "]" + message);
    }

    public List<String> getEntityStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\tentities: {" + (this.entitiesSpawned.isEmpty() ? "}" : ""));
        ArrayList<MobEntity> entitylist = new ArrayList<MobEntity>(this.entitiesSpawned);
        for (int i = 0; i < entitylist.size(); i += 10) {
            List sublist = entitylist.subList(i, Math.min(i + 9, entitylist.size() - 1));
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t");
            for (MobEntity entity : sublist) {
                builder.append(entity.getClass().getSimpleName() + "@");
                builder.append(Integer.toHexString(entity.hashCode()));
                if (entitylist.indexOf(entity) >= entitylist.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            result.add(builder.toString());
        }
        return result;
    }

    @Override
    public void reset(ServerWorld world) {
        this.entitiesSpawned.clear();
        HordeWorldData data = HordeWorldData.getData(world);
        this.nextDay = data.getNextDay();
    }
}

